(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    177158,       3991]
NotebookOptionsPosition[    165627,       3710]
NotebookOutlinePosition[    166014,       3726]
CellTagsIndexPosition[    165971,       3723]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Math 203 - Multivariable Calculus", "Title",
 CellChangeTimes->{{3.7132352480035334`*^9, 3.7132352566671543`*^9}, {
  3.7132353840015993`*^9, 
  3.713235386162277*^9}},ExpressionUUID->"3eff84e4-7dc3-473c-9d5f-\
5004e7960755"],

Cell[CellGroupData[{

Cell[TextData[{
 "The Cross Product\n",
 StyleBox["September 11, 2017", "Subchapter"]
}], "Chapter",
 CellChangeTimes->{{3.7132354004820967`*^9, 3.713235406034102*^9}, {
  3.713236857004621*^9, 3.713236868548688*^9}, {3.7134660159867067`*^9, 
  3.7134660259792247`*^9}, {3.7136367302253275`*^9, 3.7136367303689313`*^9}, {
  3.7136390134313707`*^9, 3.713639019486205*^9}, {3.7138289066862593`*^9, 
  3.713828911468053*^9}, {3.714057515975712*^9, 
  3.7140575196396585`*^9}},ExpressionUUID->"5b65f4e8-cea9-44b9-aede-\
fa6ba26bdd89"],

Cell["\<\
This link has a list of keyboard shortcuts for Mathematica. This can make \
entering integrals, derivatives, and other things easier! \
\>", "Text",
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 3.713465718323245*^9}, {3.7134658334571447`*^9, 
  3.713465872458172*^9}},ExpressionUUID->"76986328-9708-4592-8069-\
c192c864c775"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<Keyboard Shortcuts\>\"", ",", 
   "\"\<http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html\>\""}], "]"}]], "Code",
 CellOpen->False,
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 
  3.7134657576928744`*^9}},ExpressionUUID->"75b51ea8-3cf4-4f7d-b8ba-\
743bdfc5b198"],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->"\<\"Keyboard Shortcuts\"\>", True->
    StyleBox["\<\"Keyboard Shortcuts\"\>", "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaseStyle->{"Hyperlink"},
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html"], None},
   ButtonNote->
    "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html"],
  Annotation[#, 
   "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.713465760187833*^9, 3.7136407538491297`*^9, 
  3.7138327273600025`*^9, 
  3.714063605757433*^9},ExpressionUUID->"706fd091-0d1c-4039-b85d-\
b12ae85a78f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1", "Section",
 CellChangeTimes->{{3.7132354217860603`*^9, 3.713235422873678*^9}, {
  3.7132357083691387`*^9, 
  3.713235713385277*^9}},ExpressionUUID->"03899cad-2d7f-4aa5-9757-\
7093b5aa4e28"],

Cell["\<\
State whether each expression is meaningful. If it is meaningful, state \
whether the output is a vector or a scalar. If it is not meaningful, state \
why.\
\>", "Text",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.713828982326439*^9}, {
   3.7140575793278756`*^9, 
   3.714057604512898*^9}},ExpressionUUID->"8ca8a4c2-3c15-486e-8538-\
896de7f66e0e"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["b", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["c", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"24575935-4de6-4b83-b2ed-913e4630d60e"],
 " is meaningful since it is the dot product of two vectors (the output of \
the cross product is a vector). The output is a scalar."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.7138292399624424`*^9}, {3.7140575338326507`*^9, 3.714057557401882*^9}, {
   3.714692419093953*^9, 
   3.714692451254718*^9}},ExpressionUUID->"d4ccd7aa-9643-465a-8ad2-\
4bcc04cc301d"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["b", "\[RightVector]"], "\[CenterDot]", 
      OverscriptBox["c", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"bfc30521-fb29-4499-9613-c0dd3398b92c"],
 " is meaningless since you cannot take the cross product of a vector and a \
scalar (the dot product inside the parentheses)."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.7138292715710607`*^9}, {3.7140576155053635`*^9, 
   3.7140576258894806`*^9}, {3.7146924553979464`*^9, 
   3.7146924824388237`*^9}},ExpressionUUID->"e90830b2-69f7-4cb8-a397-\
821128b6c822"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["b", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["c", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"82fccb7a-cef5-42ed-b579-becc378f6c2d"],
 " is meaningful since it is the cross product of two vectors. The output is \
a vector."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.7138293052591085`*^9}, {3.7140576345716467`*^9, 
   3.7140576426253023`*^9}, {3.7146924867749014`*^9, 
   3.714692501223596*^9}},ExpressionUUID->"2108ade3-702e-4645-8ac4-\
f63d285d0ca7"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["b", "\[RightVector]"], "\[CenterDot]", 
      OverscriptBox["c", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"4a6a1212-eea7-442c-8a2d-e87c5ae0a35c"],
 " is meaningless since you cannot take the dot product of a vector and a \
scalar (the expression inside the parentheses)."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.71382934190825*^9}, {3.714057652306275*^9, 3.7140576534588623`*^9}, {
   3.7146925049106483`*^9, 
   3.7146925254633512`*^9}},ExpressionUUID->"6f434200-6a5e-4a4c-a90f-\
e7a7458fb6e7"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
      OverscriptBox["b", "\[RightVector]"]}], ")"}], "\[Cross]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["c", "\[RightVector]"], "\[CenterDot]", 
      OverscriptBox["d", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"4fa7eac7-f7d1-43d7-bc57-bd05340e490c"],
 " is meaningless since you cannot take the cross product of two scalars. The \
expression inside both sets of parentheses are scalars."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.713829362355802*^9}, {3.714057660424808*^9, 3.71405768374129*^9}, {
   3.7146925289430003`*^9, 
   3.714692564935464*^9}},ExpressionUUID->"22e5d1a4-0b06-45fb-9a27-\
ba314667b789"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["b", "\[RightVector]"]}], ")"}], "\[CenterDot]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["c", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["d", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"65340b47-867e-499d-bfd6-ac330e4553ee"],
 " is meaningful since it is the dot product of two vectors (the expressions \
inside both sets of parentheses are vectors). The output is a scalar."
}], "ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.713829393573675*^9}, {3.714057696433014*^9, 3.714057712626872*^9}, {
   3.714692568735669*^9, 
   3.7146926001043468`*^9}},ExpressionUUID->"0ae83a95-bb90-400b-9f61-\
9d78ddf8adbf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 2", "Section",
 CellChangeTimes->{{3.7132357351372943`*^9, 
  3.7132357361843896`*^9}},ExpressionUUID->"38cc62da-8763-4d8f-ac77-\
780f62bc6421"],

Cell[TextData[{
 "Compute the cross product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
    OverscriptBox["v", "\[RightVector]"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9e49f622-e5f6-4fba-b913-e493b45847c2"],
 " for the following pairs of vectors:"
}], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 
   3.714057735396927*^9}},ExpressionUUID->"b5fb625e-5ac9-4c5b-a73a-\
901fa400cef1"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"6", ",", "0", ",", 
      RowBox[{"-", "2"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  ExpressionUUID->"892720d7-f1f1-46c5-81c8-508849386ef3"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"0", ",", "8", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],ExpressionUUID->"1fe7b8a8-3ba7-4c00-bab6-5fc70345b3dc"]
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829598022792*^9}, {
   3.7138296714885693`*^9, 3.7138297365061035`*^9}, {3.714057953477021*^9, 
   3.714057972778011*^9}, {3.7140681039385996`*^9, 
   3.7140681123453846`*^9}},ExpressionUUID->"b2988ef3-402d-4aab-9f99-\
cca069ecce0b"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "=", 
    RowBox[{
     OverscriptBox["j", "^"], "+", 
     RowBox[{"7", 
      OverscriptBox["k", "^"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9ecb4b7a-0ba0-4878-9537-ce5ef8939b89"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"2", 
      OverscriptBox["i", "^"]}], "-", 
     OverscriptBox["j", "^"], "+", 
     RowBox[{"4", 
      OverscriptBox["k", "^"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "17d59b44-8cc9-40b0-aa64-87759e8bd0de"]
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829598022792*^9}, {
   3.7138296714885693`*^9, 3.7138297155850883`*^9}, {3.713829767043283*^9, 
   3.71382984619882*^9}, {3.7138725072642145`*^9, 3.7138725604186316`*^9}, {
   3.714058499202015*^9, 3.7140585386492653`*^9}, {3.7140585908585997`*^9, 
   3.7140585908585997`*^9}},ExpressionUUID->"41803f9c-cae0-43bb-9d02-\
721271aa32bb"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"t", " ", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"cos", " ", "t", " ", 
      OverscriptBox["j", "^"]}], "+", " ", 
     RowBox[{"sin", " ", "t", " ", 
      OverscriptBox["k", "^"]}]}]}], ",", " ", 
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{
     OverscriptBox["i", "^"], "-", " ", 
     RowBox[{"sin", " ", "t", " ", 
      OverscriptBox["j", "^"]}], " ", "+", " ", 
     RowBox[{"cos", " ", "t", " ", 
      OverscriptBox["k", "^"]}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"009a7071-afbc-4ad9-b076-d3eccf9b5b37"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829598022792*^9}, {
   3.7138296714885693`*^9, 3.7138297159526176`*^9}, {3.7138298542530317`*^9, 
   3.713829921027093*^9}, {3.714058551993705*^9, 
   3.714058673918182*^9}},ExpressionUUID->"252a1eac-647b-4a36-a985-\
d94fc1b875a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714692622064413*^9, 
  3.7146926315848966`*^9}},ExpressionUUID->"d8c1f8fe-1eb1-4df7-b516-\
2348173a1ba6"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
    OverscriptBox["v", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", GridBox[{
       {
        OverscriptBox["i", "^"], 
        OverscriptBox["j", "^"], 
        OverscriptBox["k", "^"]},
       {"6", "0", 
        RowBox[{"-", "2"}]},
       {"0", "8", "0"}
      }], "\[RightBracketingBar]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0", "-", 
         RowBox[{"(", 
          RowBox[{"-", "16"}], ")"}]}], ")"}], 
       OverscriptBox["i", "^"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0", "-", "0"}], ")"}], 
       OverscriptBox["j", "^"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"48", "-", "0"}], ")"}], 
       OverscriptBox["k", "^"]}]}], "=", 
     RowBox[{
      RowBox[{"16", 
       OverscriptBox["i", "^"]}], "+", 
      RowBox[{"48", 
       OverscriptBox["k", "^"]}]}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"19cfaff2-1e32-408c-9192-303f849557bf"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714692622064413*^9, 3.7146926301759377`*^9}, {
  3.714692675028641*^9, 3.714692733531633*^9}, {3.714692845278361*^9, 
  3.7146929231460934`*^9}, {3.7146931044773245`*^9, 
  3.714693115935132*^9}},ExpressionUUID->"a3e2c17a-f982-4034-b869-\
fa80c5b7e467"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
    OverscriptBox["v", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", GridBox[{
       {
        OverscriptBox["i", "^"], 
        OverscriptBox["j", "^"], 
        OverscriptBox["k", "^"]},
       {"0", "1", "7"},
       {"2", 
        RowBox[{"-", "1"}], "4"}
      }], "\[RightBracketingBar]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"(", 
          RowBox[{"-", "7"}], ")"}]}], ")"}], 
       OverscriptBox["i", "^"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0", "-", "14"}], ")"}], 
       OverscriptBox["j", "^"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0", "-", "2"}], ")"}], 
       OverscriptBox["k", "^"]}]}], "=", 
     RowBox[{
      RowBox[{"11", 
       OverscriptBox["i", "^"]}], "+", 
      RowBox[{"14", 
       OverscriptBox["j", "^"]}], "-", 
      RowBox[{"2", 
       OverscriptBox["k", "^"]}]}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"c56722c2-e54f-48d0-a34b-ae6af54b3d84"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714692622064413*^9, 3.7146926301759377`*^9}, {
  3.714692675028641*^9, 3.714692733531633*^9}, {3.714692845278361*^9, 
  3.71469298252448*^9}, {3.714693118957465*^9, 
  3.7146931279745555`*^9}},ExpressionUUID->"121ef57f-3097-49cb-8529-\
4103f5875495"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
    OverscriptBox["v", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", GridBox[{
       {
        OverscriptBox["i", "^"], 
        OverscriptBox["j", "^"], 
        OverscriptBox["k", "^"]},
       {"t", 
        RowBox[{"cos", " ", "t"}], 
        RowBox[{"sin", " ", "t"}]},
       {"1", 
        RowBox[{
         RowBox[{"-", "sin"}], " ", "t"}], 
        RowBox[{"cos", " ", "t"}]}
      }], "\[RightBracketingBar]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["cos", "2"], "t"}], "-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["sin", "2"]}], "t"}], ")"}]}], ")"}], 
       OverscriptBox["i", "^"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"t", " ", "cos", " ", "t"}], "-", 
         RowBox[{"sin", " ", "t"}]}], ")"}], 
       OverscriptBox["j", "^"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "t"}], " ", "sin", " ", "t"}], "-", 
         RowBox[{"cos", " ", "t"}]}], ")"}], 
       OverscriptBox["k", "^"]}]}], "=", 
     RowBox[{
      OverscriptBox["i", "^"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", " ", "t"}], "-", 
         RowBox[{"t", " ", "cos", " ", "t"}]}], ")"}], 
       OverscriptBox["j", "^"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"t", " ", "sin", " ", "t"}], "+", 
         RowBox[{"cos", " ", "t"}]}], ")"}], 
       OverscriptBox["k", "^"]}]}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"cf86df4b-a095-4050-b72d-4560f10fb929"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714692622064413*^9, 3.7146926301759377`*^9}, {
  3.714692675028641*^9, 3.714692733531633*^9}, {3.714692845278361*^9, 
  3.714692925197777*^9}, {3.7146929941009507`*^9, 3.7146930889833326`*^9}, {
  3.7146931306623497`*^9, 
  3.7146931367268753`*^9}},ExpressionUUID->"1a741c99-723c-475d-b71b-\
94a6ca28a1b3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 3", "Section",
 CellChangeTimes->{{3.7132359950315733`*^9, 
  3.713235996879508*^9}},ExpressionUUID->"b558e9de-89e6-468c-a384-\
951f2a0bdef8"],

Cell["\<\
Find the vector, not with determinants (or calculators), but by using \
properties of cross products.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 3.7140589627666883`*^9}, 
   3.7140589981439013`*^9},ExpressionUUID->"174c6873-057c-4455-bb2c-\
f643f624b6ff"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["i", "^"], "\[Cross]", 
     OverscriptBox["j", "^"]}], ")"}], "\[Cross]", 
   OverscriptBox["k", "^"]}], 
  TraditionalForm]],ExpressionUUID->"bbad63ba-6ab2-4bea-b03c-0c18646cce53"]], \
"ItemNumbered",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 
   3.7140589627666883`*^9}, {3.7140590099665728`*^9, 3.714059028848516*^9}, {
   3.714063504940621*^9, 
   3.714063504941622*^9}},ExpressionUUID->"f8e2e0c7-736a-4958-8911-\
8846b778879c"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["i", "^"], "\[Cross]", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["j", "^"], "\[Cross]", 
     OverscriptBox["k", "^"]}], ")"}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"16fa5f1c-5713-4d85-80da-9a04a87f6078"]], \
"ItemNumbered",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 
   3.7140589627666883`*^9}, {3.7140590099665728`*^9, 3.714059028848516*^9}, {
   3.7140635073233204`*^9, 
   3.7140635307259045`*^9}},ExpressionUUID->"970dff80-1b18-4579-9d8f-\
60558dd36a98"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["k", "^"], "\[Cross]", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["i", "^"], "-", 
     RowBox[{"2", 
      OverscriptBox["j", "^"]}]}], ")"}]}], 
  TraditionalForm]],ExpressionUUID->"b8bd423f-c363-4822-854c-86a26b17dec0"]], \
"ItemNumbered",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 
   3.7140589627666883`*^9}, {3.7140590099665728`*^9, 
   3.714059057216946*^9}},ExpressionUUID->"ba274bf8-5935-4616-820b-\
611606e90702"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["i", "^"], "+", 
     OverscriptBox["j", "^"]}], ")"}], "\[Cross]", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["i", "^"], "-", 
     OverscriptBox["j", "^"]}], ")"}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"e5a70030-abd9-45f4-937e-76f58dd54a2c"]], \
"ItemNumbered",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 
   3.7140589627666883`*^9}, {3.7140590099665728`*^9, 
   3.7140590888395777`*^9}},ExpressionUUID->"dde223e0-5eb6-44a7-ade8-\
61ff0402378f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7146931707167606`*^9, 
  3.7146931731982*^9}},ExpressionUUID->"746d3e2f-8edf-4547-a337-f178995e2ac8"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["i", "^"], "\[Cross]", 
      OverscriptBox["j", "^"]}], ")"}], "\[Cross]", 
    OverscriptBox["k", "^"]}], "=", 
   RowBox[{
    RowBox[{
     OverscriptBox["k", "^"], "\[Cross]", 
     OverscriptBox["k", "^"]}], "=", 
    OverscriptBox["0", "\[RightVector]"]}]}], 
  TraditionalForm]],ExpressionUUID->"08273902-73d0-4f34-b539-6e209c44b974"]], \
"ItemNumbered",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 
   3.7140589627666883`*^9}, {3.7140590099665728`*^9, 3.714059028848516*^9}, {
   3.714063504940621*^9, 3.714063504941622*^9}, {3.714693197014866*^9, 
   3.7146932197432613`*^9}},ExpressionUUID->"6377f3ab-94ce-4b6f-822a-\
bb887fd1595c"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["i", "^"], "\[Cross]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["j", "^"], "\[Cross]", 
      OverscriptBox["k", "^"]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     OverscriptBox["i", "^"], "\[Cross]", 
     RowBox[{"(", 
      RowBox[{"-", 
       OverscriptBox["i", "^"]}], ")"}]}], "=", 
    OverscriptBox["0", "\[RightVector]"]}]}], 
  TraditionalForm]],ExpressionUUID->"e3b57689-ab66-44ff-b7c2-945a6d3d5370"]], \
"ItemNumbered",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 
   3.7140589627666883`*^9}, {3.7140590099665728`*^9, 3.714059028848516*^9}, {
   3.7140635073233204`*^9, 3.7140635307259045`*^9}, {3.714693226469496*^9, 
   3.7146932597152348`*^9}},ExpressionUUID->"e144aa2f-c0c1-436f-879f-\
3920aa31f1c1"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["k", "^"], "\[Cross]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["i", "^"], "-", 
      RowBox[{"2", 
       OverscriptBox["j", "^"]}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      OverscriptBox["k", "^"], "\[Cross]", 
      OverscriptBox["i", "^"]}], "-", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["k", "^"], "\[Cross]", 
        OverscriptBox["j", "^"]}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{
      OverscriptBox["j", "^"], "-", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"-", 
         OverscriptBox["i", "^"]}], ")"}]}]}], "=", 
     RowBox[{
      RowBox[{"2", 
       OverscriptBox["i", "^"]}], "+", 
      OverscriptBox["j", "^"]}]}]}]}], 
  TraditionalForm]],ExpressionUUID->"e2162a61-8043-4ef5-a190-2d2200216b8d"]], \
"ItemNumbered",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 
   3.7140589627666883`*^9}, {3.7140590099665728`*^9, 3.714059057216946*^9}, {
   3.7146932660539875`*^9, 
   3.7146933406641445`*^9}},ExpressionUUID->"9356d0e0-99e9-41dd-80ab-\
2071f980df02"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["i", "^"], "+", 
      OverscriptBox["j", "^"]}], ")"}], "\[Cross]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["i", "^"], "-", 
      OverscriptBox["j", "^"]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["i", "^"], "\[Cross]", 
       OverscriptBox["i", "^"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["i", "^"], "\[Cross]", 
       OverscriptBox["j", "^"]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["j", "^"], "\[Cross]", 
       OverscriptBox["i", "^"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["j", "^"], "\[Cross]", 
       OverscriptBox["j", "^"]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{
      OverscriptBox["0", "\[RightVector]"], "-", 
      OverscriptBox["k", "^"], "+", 
      RowBox[{"(", 
       RowBox[{"-", 
        OverscriptBox["k", "^"]}], ")"}], "-", 
      OverscriptBox["0", "\[RightVector]"]}], "=", 
     RowBox[{
      RowBox[{"-", "2"}], 
      OverscriptBox["k", "^"]}]}]}]}], 
  TraditionalForm]],ExpressionUUID->"67a2b1ca-dee2-45f8-a671-80d726528ebe"]], \
"ItemNumbered",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 
   3.7140589627666883`*^9}, {3.7140590099665728`*^9, 
   3.7140590888395777`*^9}, {3.7146933500555153`*^9, 
   3.7146934718033247`*^9}},ExpressionUUID->"c5113f79-2815-4449-913d-\
ac062677719e"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 4", "Section",
 CellChangeTimes->{{3.713235999118843*^9, 
  3.7132360046164513`*^9}},ExpressionUUID->"d9f59dcc-177e-49cd-b037-\
24d5bddbc1a0"],

Cell[TextData[{
 "For the following two pairs of vectors, find ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
     OverscriptBox["v", "\[RightVector]"]}], "||"}], TraditionalForm]],
  ExpressionUUID->"55915d7e-1879-4acc-85c9-70af119a567d"],
 " and determine whether ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
    OverscriptBox["v", "\[RightVector]"]}], TraditionalForm]],ExpressionUUID->
  "8a79e14d-2eec-40c1-96a8-1a794431c955"],
 " is directed into the screen or out of the screen."
}], "Text",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}, {3.713646471249406*^9, 3.713646631537095*^9}, {
   3.713651581074431*^9, 3.7136515819870415`*^9}, {3.713833128184634*^9, 
   3.713833157380231*^9}, {3.7140591051033754`*^9, 3.7140591641839914`*^9}, {
   3.714060409067382*^9, 
   3.7140604184432797`*^9}},ExpressionUUID->"96795a05-1591-4a13-b703-\
2430f29274a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Thick", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"4", "/", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", "2", ")"}]}]}], ",", 
           RowBox[{
            RowBox[{"-", "4"}], "/", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", "2", ")"}]}]}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<45\[Degree]\>\"", ",", "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.2", ",", 
          RowBox[{"-", "0.4"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<||\!\(\*OverscriptBox[\(u\), \(\[RightVector]\)]\)||=4\>\"", 
          ",", "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.9", ",", 
          RowBox[{"-", "1.6"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<||\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)||=5\>\"", 
          ",", "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.5", ",", "0.3"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.75", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"0.75", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       FractionBox[
        RowBox[{"7", "\[Pi]"}], "4"], ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.7140592466030645`*^9, 3.7140592547286525`*^9}, {
  3.714059329452586*^9, 3.7140594714049425`*^9}, {3.71405965951436*^9, 
  3.7140599507587957`*^9}, {3.714060582558305*^9, 3.7140606073600407`*^9}, {
  3.714060652464489*^9, 3.714060653161399*^9}, {3.7140635987350426`*^9, 
  3.7140636203302035`*^9}},ExpressionUUID->"fdcd992f-ba4a-47a9-8c36-\
5a00cff3243d"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Thickness[Large], ArrowBox[{{0, 0}, {5, 0}}], 
    ArrowBox[NCache[{{0, 0}, {2 2^Rational[1, 2], (-2) 2^Rational[1, 2]}}, {{
       0, 0}, {2.8284271247461903`, -2.8284271247461903`}}]]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"45\[Degree]\"\>",
      StripOnInput->False,
      FontSize->Large], {1.2, -0.4}], InsetBox[
     StyleBox["\<\"||\\!\\(\\*OverscriptBox[\\(u\\), \
\\(\[RightVector]\\)]\\)||=4\"\>",
      StripOnInput->False,
      FontSize->Large], {0.9, -1.6}], InsetBox[
     StyleBox["\<\"||\\!\\(\\*OverscriptBox[\\(v\\), \
\\(\[RightVector]\\)]\\)||=5\"\>",
      StripOnInput->False,
      FontSize->Large], {2.5, 0.3}]}, {{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
      Opacity[0.3]], LineBox[CompressedData["
1:eJwl0gk41FsbAHBNdftCaZtLhLhTSWWJbMlJKpKkBZWuiSJNQhHqkiwRsl5b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       "]]},
     Annotation[#, "Charting`Private`Tag$37945#1"]& ]}}]], "Output",
 CellChangeTimes->{{3.7140594667810435`*^9, 3.7140594740352836`*^9}, 
   3.7140596644675274`*^9, {3.7140597084325094`*^9, 3.7140597920668983`*^9}, {
   3.714059858353463*^9, 3.714059951530634*^9}, {3.714060593547719*^9, 
   3.714060607799407*^9}, 3.7140608095996428`*^9, {3.7140636058761873`*^9, 
   3.714063627256675*^9}},ExpressionUUID->"33a6342d-85c4-412a-b8a2-\
f278541c857f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Thick", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"16", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", 
           RowBox[{
            RowBox[{"-", "6"}], 
            SqrtBox["2"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<120\[Degree]\>\"", ",", "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"-", "3"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<||\!\(\*OverscriptBox[\(u\), \(\[RightVector]\)]\)||=12\>\"", 
          ",", "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "6.5"}], ",", 
          RowBox[{"-", "4"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<||\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)||=16\>\"", 
          ",", "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"8", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"2", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       FractionBox[
        RowBox[{"4", "\[Pi]"}], "3"], ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.7140599696287327`*^9, 3.714059970238331*^9}, {
  3.714060267547408*^9, 
  3.7140605185337477`*^9}},ExpressionUUID->"2c6bbcd0-c436-44ce-9791-\
808b460f5cab"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Thickness[Large], ArrowBox[{{0, 0}, {16, 0}}], 
    ArrowBox[NCache[{{-6, (-6) 2^Rational[1, 2]}, {0, 
       0}}, {{-6, -8.485281374238571}, {0, 0}}]]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"120\[Degree]\"\>",
      StripOnInput->False,
      FontSize->Large], {3, -3}], InsetBox[
     StyleBox["\<\"||\\!\\(\\*OverscriptBox[\\(u\\), \
\\(\[RightVector]\\)]\\)||=12\"\>",
      StripOnInput->False,
      FontSize->Large], {-6.5, -4}], InsetBox[
     StyleBox["\<\"||\\!\\(\\*OverscriptBox[\\(v\\), \
\\(\[RightVector]\\)]\\)||=16\"\>",
      StripOnInput->False,
      FontSize->Large], {8, 1.5}]}, {{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
      Opacity[0.3]], LineBox[CompressedData["
1:eJwl13c01f//AHAhLYUoFVIqUWYls158rFBCVqXxpYQyE4VIoZKVGdIwMhv2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       "]]},
     Annotation[#, "Charting`Private`Tag$32980#1"]& ]}},
  ImageSize->{455., Automatic}]], "Output",
 CellChangeTimes->{{3.7140602905092974`*^9, 3.714060321710803*^9}, {
  3.7140603572636123`*^9, 3.7140603972642407`*^9}, {3.7140604368899965`*^9, 
  3.714060442585868*^9}, {3.7140604957619753`*^9, 
  3.7140605198282404`*^9}},ExpressionUUID->"df386c2c-711d-413c-a4a1-\
7224d0a06924"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7146934862320986`*^9, 
  3.7146934898330293`*^9}},ExpressionUUID->"b67230a7-ccfa-481f-a426-\
cf74c75e5d19"],

Cell[CellGroupData[{

Cell[TextData[{
 "Just apply the cross product magnitude formula: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     RowBox[{
      OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["v", "\[RightVector]"]}], "||"}], "=", 
    RowBox[{
     RowBox[{"||", 
      OverscriptBox["u", "\[RightVector]"], "||", " ", "||", 
      OverscriptBox["v", "\[RightVector]"], "||", 
      RowBox[{"sin", " ", "\[Theta]"}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "4", ")"}], 
       RowBox[{"(", "5", ")"}], "sin", " ", "45", "\[Degree]"}], "=", 
      RowBox[{"10", 
       SqrtBox["2"]}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "30a20a87-9f32-4990-ab21-e16463054e4c"],
 ". Following the right hand rule with ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["u", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "626252ae-2f6b-412c-bd47-ce23e96f1d4c"],
 " as the first vector and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "04d58a07-4625-4aa3-9710-46fc55e99cb5"],
 " as the second, we see that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
    OverscriptBox["v", "\[RightVector]"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "36321f12-2eee-4b38-9d78-30f28e8ca477"],
 " comes out of the screen."
}], "ItemNumbered",
 CellChangeTimes->{{3.7146934862320986`*^9, 3.714693486935142*^9}, {
  3.71469370162192*^9, 
  3.7146938519608912`*^9}},ExpressionUUID->"ebc36f3f-c875-47c6-8968-\
0f2ab9981cb6"],

Cell[TextData[{
 "First, note that the angle we need to measure between the vectors needs to \
be measured when the vectors are attached at the tail. Sliding ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["u", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "0bc78fff-549c-4794-b472-22c4e86e3145"],
 " up so that the two vectors meet at their tails, we see that the angle \
between them is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"60", "\[Degree]"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9e4446d0-0c06-4c10-9c44-6f8b2a88c7f1"],
 ". Now, apply the cross product magnitude formula: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     RowBox[{
      OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["v", "\[RightVector]"]}], "||"}], "=", 
    RowBox[{
     RowBox[{"||", 
      OverscriptBox["u", "\[RightVector]"], "||", " ", "||", 
      OverscriptBox["v", "\[RightVector]"], "||", 
      RowBox[{"sin", " ", "\[Theta]"}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "12", ")"}], 
       RowBox[{"(", "16", ")"}], "sin", " ", "60", "\[Degree]"}], "=", 
      RowBox[{"96", 
       SqrtBox["3"]}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "97eb8e17-24a8-44ee-9ded-963e52453422"],
 ". Following the right hand rule with ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["u", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "dfe0c2ac-4b35-42e2-8d1f-0b7ac9061eea"],
 " as the first vector and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f6182ff0-815a-4d91-a91d-df4b05c2a328"],
 " as the second, we see that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[Cross]", 
    OverscriptBox["v", "\[RightVector]"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "53e96422-c9c1-4501-9761-26f5237168c1"],
 " goes into the screen."
}], "ItemNumbered",
 CellChangeTimes->{{3.7146934862320986`*^9, 3.714693486935142*^9}, {
  3.71469370162192*^9, 
  3.7146939811115875`*^9}},ExpressionUUID->"077aff88-f865-4e7c-9cbe-\
ad2ea2824a44"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 5", "Section",
 CellChangeTimes->{{3.7140619948143387`*^9, 
  3.71406199930182*^9}},ExpressionUUID->"51845899-4359-4829-b905-\
84276d313cc9"],

Cell[TextData[{
 "Given that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
     OverscriptBox["b", "\[RightVector]"]}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "2", ",", "1"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],ExpressionUUID->"6a7128f5-03e5-4d00-a4dd-3c2160a7d378"],
 ", compute the following vector operation:"
}], "Text",
 CellChangeTimes->{{3.7140619948143387`*^9, 3.7140620765193305`*^9}, {
  3.714068117623251*^9, 
  3.714068120505478*^9}},ExpressionUUID->"67bd11bf-8581-4bcc-a90a-\
f92da96d15ea"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", 
       OverscriptBox["a", "\[RightVector]"]}], "+", 
      OverscriptBox["b", "\[RightVector]"]}], ")"}], "\[Cross]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["a", "\[RightVector]"], "-", 
      OverscriptBox["b", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"49b2c3ba-10f7-4ecf-9775-99bdca1a628a"],
 "."
}], "Text",
 CellChangeTimes->{{3.7140619948143387`*^9, 3.7140621458043623`*^9}},
 TextAlignment->Center,ExpressionUUID->"24c4f408-caed-41cc-adfb-3d60c340697f"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714693990047005*^9, 
  3.714693992352748*^9}},ExpressionUUID->"b9237059-50ba-4048-a08f-\
ef2addf70aa9"],

Cell["\<\
Use the properties of the cross product to expand and simplify this \
expression:\
\>", "Text",
 CellChangeTimes->{{3.714693990047005*^9, 3.7146940053843737`*^9}, {
  3.714694228928233*^9, 
  3.7146942335603437`*^9}},ExpressionUUID->"67a2ee23-73e4-43f2-9160-\
e0c84287d950"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", 
             OverscriptBox["a", "\[RightVector]"]}], "+", 
            OverscriptBox["b", "\[RightVector]"]}], ")"}], "\[Cross]", 
          RowBox[{"(", 
           RowBox[{
            OverscriptBox["a", "\[RightVector]"], "-", 
            OverscriptBox["b", "\[RightVector]"]}], ")"}]}], "=", 
         RowBox[{
          RowBox[{"2", 
           RowBox[{"(", 
            RowBox[{
             OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
             OverscriptBox["a", "\[RightVector]"]}], ")"}]}], "-", 
          RowBox[{"2", 
           RowBox[{"(", 
            RowBox[{
             OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
             OverscriptBox["b", "\[RightVector]"]}], ")"}]}], "+", 
          RowBox[{"(", 
           RowBox[{
            OverscriptBox["b", "\[RightVector]"], "\[Cross]", 
            OverscriptBox["a", "\[RightVector]"]}], ")"}], "-", 
          RowBox[{"(", 
           RowBox[{
            OverscriptBox["b", "\[RightVector]"], "\[Cross]", 
            OverscriptBox["b", "\[RightVector]"]}], ")"}]}]}]},
       {
        RowBox[{"=", 
         RowBox[{
          RowBox[{"2", 
           StyleBox[
            OverscriptBox[
             StyleBox["0", "Text"], "\[RightVector]"], "Text"]}], 
          StyleBox["-", "Text"], 
          RowBox[{
           StyleBox["2", "Text"], 
           RowBox[{
            OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
            OverscriptBox["b", "\[RightVector]"]}]}], "+", 
          RowBox[{"(", 
           RowBox[{"-", 
            RowBox[{
             OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
             OverscriptBox["b", "\[RightVector]"]}]}], ")"}], "-", 
          OverscriptBox["0", "\[RightVector]"]}]}]},
       {
        RowBox[{"=", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], 
           RowBox[{
            OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
            OverscriptBox["b", "\[RightVector]"]}]}], " ", "=", " ", 
          RowBox[{"\[LeftAngleBracket]", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "6"}], ",", 
            RowBox[{"-", "3"}]}], "\[RightAngleBracket]"}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"42283d5f-a231-49b1-9509-05442943a31f"]], \
"Text",
 CellChangeTimes->{{3.7146940192508073`*^9, 
  3.714694201336746*^9}},ExpressionUUID->"0eb97ab2-def0-4c3c-ad80-\
1af415e70ae6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 6", "Section",
 CellChangeTimes->{{3.7132360117278037`*^9, 3.7132360131111164`*^9}, 
   3.713236527279331*^9, {3.7140621526354446`*^9, 3.714062155403966*^9}, 
   3.7140622114516797`*^9},ExpressionUUID->"8a849707-7d64-4ab6-84bd-\
d2ca7003e56a"],

Cell[TextData[{
 "Find two unit vectors orthogonal to both ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "\[RightAngleBracket]"}], 
   TraditionalForm]],ExpressionUUID->"4cf6f8c8-d08c-4056-bf61-1005637320cd"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"4", ",", "2", ",", "1"}], "\[RightAngleBracket]"}], 
   TraditionalForm]],ExpressionUUID->"895e74de-9971-4c8c-909e-454c551537e1"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236605121499*^9}, {
   3.7136468336609907`*^9, 3.7136468362360744`*^9}, {3.7136469530118275`*^9, 
   3.7136469884451237`*^9}, {3.713647080759206*^9, 3.713647095429121*^9}, {
   3.71364721831068*^9, 3.7136472292706084`*^9}, 3.7138335573096704`*^9, {
   3.713833824080535*^9, 3.7138338623458776`*^9}, 3.7138339340870676`*^9, {
   3.7140612265715113`*^9, 3.714061277211094*^9}, {3.714068124440487*^9, 
   3.714068133768079*^9}},ExpressionUUID->"2ccb428a-117c-4cd2-9f13-\
4839352852dc"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7146942400406647`*^9, 
  3.714694244339056*^9}},ExpressionUUID->"b03bd0d6-14f8-409f-9edc-\
ca5199e31c7b"],

Cell["\<\
Begin by finding a vector which is orthogonal to both vectors by taking the \
cross product:\
\>", "Text",
 CellChangeTimes->{{3.7146942400406647`*^9, 
  3.714694266046486*^9}},ExpressionUUID->"437800bd-4d36-4c42-9dfb-\
d0d29d1b01ea"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["v", "\[RightVector]"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}], ",", "3"}], "\[RightAngleBracket]"}], "\[Cross]", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"4", ",", "2", ",", "1"}], "\[RightAngleBracket]"}]}], "=", 
    RowBox[{
     RowBox[{"\[LeftBracketingBar]", GridBox[{
        {
         OverscriptBox["i", "^"], 
         OverscriptBox["j", "^"], 
         OverscriptBox["k", "^"]},
        {"2", 
         RowBox[{"-", "1"}], "3"},
        {"4", "2", "1"}
       }], "\[RightBracketingBar]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "6"}], ")"}], 
        OverscriptBox["i", "^"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "-", "12"}], ")"}], 
        OverscriptBox["j", "^"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "-", 
          RowBox[{"(", 
           RowBox[{"-", "4"}], ")"}]}], ")"}], 
        OverscriptBox["k", "^"]}]}], "=", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{
        RowBox[{"-", "7"}], ",", "10", ",", "8"}], 
       "\[RightAngleBracket]"}]}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"7f9c034b-f0b0-4c6e-8515-cf68b5218f63"]], \
"Text",
 CellChangeTimes->{{3.7146942400406647`*^9, 3.7146943955870943`*^9}, {
  3.714694437220771*^9, 3.7146944406120024`*^9}},
 TextAlignment->Center,ExpressionUUID->"0eba511b-0dd1-41d5-88c4-a215def4a7cb"],

Cell["\<\
Find one unit vector by doing the usual \[OpenCurlyDoubleQuote]divide by the \
magnitude\[CloseCurlyDoubleQuote] technique:\
\>", "Text",
 CellChangeTimes->{{3.7146944008151684`*^9, 
  3.714694432282786*^9}},ExpressionUUID->"1148cb5b-91b6-415e-a568-\
d80b08d86015"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{"||", 
        OverscriptBox["v", "\[RightVector]"], "||"}], "\[AlignmentMarker]", 
       "=", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "7"}], ")"}], "2"], "+", 
          SuperscriptBox["10", "2"], "+", 
          SuperscriptBox["8", "2"]}]], "=", 
        RowBox[{
         SqrtBox[
          RowBox[{"49", "+", "100", "+", "64"}]], "=", 
         SqrtBox["213"]}]}]}], "\[IndentingNewLine]", 
      StyleBox[
       RowBox[{
        OverscriptBox["v", "^"], "=", 
        RowBox[{
         FractionBox[
          OverscriptBox["v", "\[RightVector]"], 
          RowBox[{"||", 
           OverscriptBox["v", "\[RightVector]"], "||"}]], "=", 
         RowBox[{
          FractionBox["1", 
           SqrtBox["213"]], 
          RowBox[{"\[LeftAngleBracket]", 
           RowBox[{
            RowBox[{"-", "7"}], ",", "10", ",", "8"}], 
           "\[RightAngleBracket]"}]}]}]}],
       FontSize->18]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"4446f26f-f192-4ec8-a448-a2bcc66316f9"]], \
"Text",
 CellChangeTimes->{{3.714694452222289*^9, 
  3.7146946084066486`*^9}},ExpressionUUID->"d316c813-33c4-4e3e-bb50-\
2e841e5f9095"],

Cell[TextData[{
 "Taking the unit vector pointing in the opposite direction as ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "^"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "25fdb182-bc7d-4aed-b325-8fcee5eae96f"],
 " is also a unit vector which is orthogonal to the original two. So our \
second vector is"
}], "Text",
 CellChangeTimes->{{3.714694633598954*^9, 
  3.7146946639015465`*^9}},ExpressionUUID->"b6093a45-6865-4df9-9d9f-\
072224b65948"],

Cell[TextData[Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    OverscriptBox["u", "^"], "=", 
    RowBox[{
     RowBox[{"-", 
      OverscriptBox["v", "^"]}], "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"-", "1"}], 
        SqrtBox["213"]], 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{
         RowBox[{"-", "7"}], ",", "10", ",", "8"}], 
        "\[RightAngleBracket]"}]}], "=", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["213"]], 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"7", ",", 
         RowBox[{"-", "0"}], ",", 
         RowBox[{"-", "8"}]}], "\[RightAngleBracket]"}]}]}]}]}],
   FontSize->18], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"535e4243-013d-4393-8369-5b2e9e72e5e0"]], \
"Text",
 CellChangeTimes->{{3.7146946752974353`*^9, 3.7146947316808815`*^9}},
 TextAlignment->Center,ExpressionUUID->"49f3a36d-146a-4c0f-a2d1-3efc2b7f348b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 7", "Section",
 CellChangeTimes->{{3.713236026463976*^9, 3.7132360275922284`*^9}, 
   3.714062161219843*^9, {3.7140621964035716`*^9, 
   3.71406221565207*^9}},ExpressionUUID->"213b8a14-dd5d-4c8b-839d-\
d0746db10921"],

Cell[TextData[{
 "Find a nonzero vector orthogonal to the plane through the points ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"P", "=", 
     RowBox[{"(", 
      RowBox[{"1", ",", "0", ",", "1"}], ")"}]}], ",", 
    RowBox[{"Q", "=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "1", ",", "3"}], ")"}]}], ",", " ", 
    RowBox[{"R", "=", 
     RowBox[{"(", 
      RowBox[{"4", ",", "2", ",", "5"}], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d642ad60-065d-40bf-a31d-7bb6a50324b2"],
 " and then find the area of the triangle ",
 Cell[BoxData[
  FormBox["PQR", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3ff170fe-762d-4cdc-b6b0-4b9abddccf72"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 3.713834609225483*^9}, {
   3.7140618261807194`*^9, 
   3.7140619126224985`*^9}},ExpressionUUID->"140bdf55-ab75-4f74-9e26-\
7f21c5377a32"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714695161073264*^9, 
  3.714695164108551*^9}},ExpressionUUID->"10c9ed3d-3556-452a-9a5e-\
b965bb42103f"],

Cell[TextData[{
 "Begin by making two vectors in the plane by creating ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["PQ", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c2b0bcd8-6b47-490c-90b4-0b175595698d"],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["PR", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "bb9e2bd7-65b7-44ea-bc41-d4fe96d515be"]
}], "Text",
 CellChangeTimes->{{3.714695161073264*^9, 
  3.714695220435541*^9}},ExpressionUUID->"f2c20206-9b40-439b-84b6-\
8839a20334e7"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         OverscriptBox["PQ", "\[RightVector]"], "=", 
         RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], "-", "1"}], ",", 
            RowBox[{"1", "-", "0"}], ",", 
            RowBox[{"3", "-", "1"}]}], "\[RightAngleBracket]"}], "=", 
          RowBox[{"\[LeftAngleBracket]", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "1", ",", "2"}], 
           "\[RightAngleBracket]"}]}]}]},
       {
        RowBox[{
         OverscriptBox["PR", "\[RightVector]"], "=", 
         RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
           RowBox[{
            RowBox[{"4", "-", "1"}], ",", 
            RowBox[{"2", "-", "0"}], ",", 
            RowBox[{"5", "-", "1"}]}], "\[RightAngleBracket]"}], "=", 
          RowBox[{"\[LeftAngleBracket]", 
           RowBox[{"3", ",", "2", ",", "4"}], "\[RightAngleBracket]"}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]],
 TextAlignment->
  Center,ExpressionUUID->"6f520838-01a6-4748-9128-cb729c901d51"]], "Text",
 CellChangeTimes->{{3.7146953254675584`*^9, 
  3.7146954238758397`*^9}},ExpressionUUID->"45026146-f1f0-4d36-8d50-\
29e2e9c8c528"],

Cell["\<\
The orthogonal vector to the plane is made by taking the cross product of \
these two vectors:\
\>", "Text",
 CellChangeTimes->{{3.714695441436617*^9, 
  3.714695461509907*^9}},ExpressionUUID->"eb6abd14-bf48-4491-8f3b-\
5ff1d0a39cc6"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["PQ", "\[RightVector]"], "\[Cross]", 
    OverscriptBox["PR", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", GridBox[{
       {
        OverscriptBox["i", "^"], 
        OverscriptBox["j", "^"], 
        OverscriptBox["k", "^"]},
       {
        RowBox[{"-", "3"}], "1", "2"},
       {"3", "2", "4"}
      }], "\[RightBracketingBar]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "-", "4"}], ")"}], 
       OverscriptBox["i", "^"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "12"}], "-", "6"}], ")"}], 
       OverscriptBox["j", "^"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "6"}], "-", "3"}], ")"}], 
       OverscriptBox["k", "^"]}]}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"0", ",", "18", ",", 
       RowBox[{"-", "9"}]}], "\[RightAngleBracket]"}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"db6c9f20-75d4-4656-bb7c-887cb84c8b46"]], \
"Text",
 CellChangeTimes->{{3.714695441436617*^9, 3.7146956147910547`*^9}},
 TextAlignment->Center,ExpressionUUID->"bf1c4e34-ff31-4b26-b47a-875cebee5fd5"],

Cell[TextData[{
 "The area of the triangle PQR is half of the magnitude of the vector we just \
found (note that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["PQ", "\[RightVector]"], "\[Cross]", 
     OverscriptBox["PR", "\[RightVector]"]}], "=", 
    RowBox[{"9", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"0", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "ad8cfa0c-c5fc-4e73-8ccd-b9bf9c2c5335"],
 "):"
}], "Text",
 CellChangeTimes->{{3.714695636000641*^9, 
  3.71469568935386*^9}},ExpressionUUID->"7afa56e8-d6b0-4e6a-908d-\
1c091be082dd"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"Area", "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "||", 
     RowBox[{
      OverscriptBox["PQ", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["PR", "\[RightVector]"]}], "||"}], "=", 
    RowBox[{
     RowBox[{
      FractionBox["9", "2"], 
      SqrtBox[
       RowBox[{"0", "+", "4", "+", "1"}]]}], "=", 
     FractionBox[
      RowBox[{"9", 
       SqrtBox["5"]}], "2"]}]}]}], TraditionalForm]],
 FormatType->"TraditionalForm",
 FontSize->18,ExpressionUUID->"73050b74-afa1-49f9-8db5-b51fd7641338"]], "Text",
 CellChangeTimes->{{3.714695636000641*^9, 3.7146957314470587`*^9}},
 TextAlignment->Center,ExpressionUUID->"bedc1797-3577-4232-8da9-78487a3b562f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 8", "Section",
 CellChangeTimes->{{3.713236030488112*^9, 3.7132360333433156`*^9}, {
  3.7140622007312565`*^9, 
  3.714062218227213*^9}},ExpressionUUID->"dae64fe3-d030-402a-99bd-\
33d99c0fb7f0"],

Cell[TextData[{
 "Find the volume of the parallelpiped determined by the vectors ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"1", ",", "2", ",", "3"}], "\[RightAngleBracket]"}]}], ",", " ", 
    RowBox[{
     OverscriptBox["b", "\[RightVector]"], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1", ",", "2"}], "\[RightAngleBracket]"}]}], 
    ",", " ", 
    RowBox[{
     OverscriptBox["c", "\[RightVector]"], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"2", ",", "1", ",", "4"}], "\[RightAngleBracket]"}]}]}], 
   TraditionalForm]],ExpressionUUID->"037f12c6-503c-4a2b-ae59-42ee9e2e6e27"],
 "."
}], "Text",
 CellChangeTimes->{{3.713236916043934*^9, 3.7132369632722015`*^9}, 
   3.7134689836990843`*^9, {3.713648970245249*^9, 3.7136489768366575`*^9}, {
   3.7136490086305647`*^9, 3.7136490799425354`*^9}, {3.7138348972093554`*^9, 
   3.7138350920889792`*^9}, {3.7140622232989607`*^9, 3.71406228622122*^9}, {
   3.7140623408122873`*^9, 3.7140623439171734`*^9}, {3.714068137920683*^9, 
   3.71406815064781*^9}},ExpressionUUID->"f42c23bc-d166-4763-8758-\
4c71e5ee6cd1"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7146957696306844`*^9, 
  3.7146957762822185`*^9}},ExpressionUUID->"b28ec24c-0567-4343-9829-\
9942f4b2bd80"],

Cell[TextData[{
 "The volume is given by the absolute value of the triple mixed product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["b", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["c", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5699e585-5acf-4abe-87ea-0aaed2003a90"],
 ":"
}], "Text",
 CellChangeTimes->{{3.7146957696306844`*^9, 
  3.714695830187855*^9}},ExpressionUUID->"c7138308-5923-4623-b72b-\
137b4b7c705a"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["b", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["c", "\[RightVector]"]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", GridBox[{
       {"1", "2", "3"},
       {
        RowBox[{"-", "1"}], "1", "2"},
       {"2", "1", "4"}
      }], "\[RightBracketingBar]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"1", 
       RowBox[{"(", 
        RowBox[{"4", "-", "2"}], ")"}]}], "-", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "-", "4"}], ")"}]}], "+", 
      RowBox[{"3", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "2"}], ")"}]}]}], "=", 
     RowBox[{
      RowBox[{"2", "+", "16", "-", "9"}], "=", "9"}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"a7e70f9c-b119-47ee-8ca9-82052a29c636"]], \
"Text",
 CellChangeTimes->{{3.7146957696306844`*^9, 3.7146958291034546`*^9}, {
  3.71469590090612*^9, 3.7146959556657133`*^9}},
 TextAlignment->Center,ExpressionUUID->"14f8a537-24c5-4633-93e4-5c6de5348b28"],

Cell[TextData[{
 "Since this is already a positive number, we have that the volume of the \
parallelpiped is ",
 Cell[BoxData[
  FormBox["9", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d002f4b5-81dd-4215-a522-f680f6bdb77a"],
 "."
}], "Text",
 CellChangeTimes->{{3.714695959538913*^9, 
  3.7146959759609394`*^9}},ExpressionUUID->"cac7b7b5-c958-423f-af62-\
62d82dc197b7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 9", "Section",
 CellChangeTimes->{{3.7132360358875327`*^9, 3.7132360371682196`*^9}, {
  3.7138351070164747`*^9, 3.7138351098009634`*^9}, {3.713835634716791*^9, 
  3.7138356364700127`*^9}, {3.7138359316568527`*^9, 3.71383593260792*^9}, {
  3.713872640299595*^9, 3.7138726413837233`*^9}, {3.714062357948083*^9, 
  3.7140623585406356`*^9}},ExpressionUUID->"64ce845d-da60-4d4e-bfd3-\
41d25d97b1d1"],

Cell[TextData[{
 "Explain how to use the triple mixed product, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["b", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["c", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4efd51ad-b4bc-4a51-99bd-261f81bd54b5"],
 ", to check whether the three vectors ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], ",", " ", 
    OverscriptBox["b", "\[RightVector]"], ",", " ", 
    OverscriptBox["c", "\[RightVector]"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "efd6dd6d-5391-4a02-8fa0-8c0b50fb383e"],
 " are coplanar and explain why that works."
}], "Text",
 CellChangeTimes->{{3.713236968060338*^9, 3.7132369811442337`*^9}, {
  3.713238103378575*^9, 3.7132381044433203`*^9}, {3.7136491318222866`*^9, 
  3.7136491741507063`*^9}, {3.713649210263423*^9, 3.7136492725515833`*^9}, {
  3.713835130857093*^9, 3.7138351684036684`*^9}, {3.7138352463860474`*^9, 
  3.713835255997469*^9}, {3.714062363084509*^9, 
  3.714062512766612*^9}},ExpressionUUID->"95b56bc2-8c0d-47d9-8d6c-\
692117207b10"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7146959835529118`*^9, 
  3.714695987275999*^9}},ExpressionUUID->"a3d9f5e9-b54b-4332-9e62-\
7a398c17f208"],

Cell[TextData[{
 "If the triple mixed product is equal to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "39213a6d-79b2-4072-a487-40c5c71e2c77"],
 ", then the three vectors are coplanar. Geometrically, this means that the \
parallelpiped has volume zero, which is only possible if the shape they span \
is 2 dimensional or less, i.e., the vectors lie in the same plane."
}], "Text",
 CellChangeTimes->{{3.7146959835529118`*^9, 
  3.714696067074356*^9}},ExpressionUUID->"f79a5bd9-821b-48df-99b5-\
2646ef9b193e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 10", "Section",
 CellChangeTimes->{{3.714063829055667*^9, 
  3.7140638395308447`*^9}},ExpressionUUID->"ed386bc4-9385-4728-a0dd-\
c3eb5d341cf5"],

Cell[TextData[{
 "A set of caliper brakes exerts a force on the rim of a bicycle wheel that \
creates a frictional force ",
 Cell[BoxData[
  FormBox[
   StyleBox["F",
    FontWeight->"Bold"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "02565b18-c796-42e9-982b-22207e3a1fc6"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"40", " ", "N"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "aebe5276-c753-4b06-8e6f-1ae8924d195c"],
 " perpendicular to the radius of the wheel (see figure). Assuming the wheel \
has a radius of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"33", "cm"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "325ae02d-4766-40c4-b594-0749410c5f34"],
 ", find the magnitude and direction of the torque about the axle of the \
wheel."
}], "Text",
 CellChangeTimes->{{3.714063829055667*^9, 3.7140638304795656`*^9}, {
  3.7140639283697686`*^9, 
  3.7140640129465027`*^9}},ExpressionUUID->"a236b3ef-4fd9-4909-982f-\
141acc7ea011"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQVUXFu2NnrevWO8/x9Pxu2+3X36xCA4IUpwD+6UF66FRolASCA4AUKA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    "], {{0, 215}, {311, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{311, 215},
  PlotRange->{{0, 311}, {0, 215}}]], "Input",
 TextAlignment->Center,ExpressionUUID->"31c5aded-e8d1-4922-ab16-6a4f9fb64101"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7146960774333825`*^9, 
  3.7146960792769556`*^9}},ExpressionUUID->"afdf70a0-5402-46d3-b9e2-\
eefb4865c38e"],

Cell[TextData[{
 "The angle between the vectors is ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["\[Pi]", "2"],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d763f961-543f-44e0-8c78-322d58b56a44"],
 ", so we have that the magnitude of the torque is: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["\[Tau]", "\[RightVector]"], "||"}], "=", 
    RowBox[{
     RowBox[{"||", 
      OverscriptBox["r", "\[RightVector]"], "||", " ", "||", 
      OverscriptBox["F", "\[RightVector]"], "||", " ", 
      RowBox[{"sin", " ", "\[Theta]"}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{".33", " ", "m"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"40", " ", "N"}], ")"}], 
       RowBox[{"(", "1", ")"}]}], "=", 
      RowBox[{"13.2", " ", 
       RowBox[{"N", "\[CenterDot]", "m"}]}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9c6c7f06-711b-44a0-b866-761bdfefb3db"],
 ". Recalling that the torque vector is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["\[Tau]", "\[RightVector]"], "=", 
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "\[Cross]", 
     OverscriptBox["F", "\[RightVector]"]}]}], TraditionalForm]],
  InitializationCell->True,
  FormatType->"TraditionalForm",ExpressionUUID->
  "579bfb46-c977-4b35-985a-e0a37be36132"],
 ", following the right hand rule, we get that the torque vector points into \
the screen."
}], "Text",
 CellChangeTimes->{{3.7146960774333825`*^9, 3.7146961303720007`*^9}, {
  3.7146961836516666`*^9, 
  3.714696314261343*^9}},ExpressionUUID->"d90634a0-cdb0-4eb5-b68b-\
9d721d2c7fab"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 11", "Section",
 CellChangeTimes->{{3.713236039199822*^9, 3.7132360418072557`*^9}, {
   3.7138352647782273`*^9, 3.7138352666392584`*^9}, {3.7138356392449474`*^9, 
   3.7138356401173787`*^9}, {3.7138359296564264`*^9, 3.7138359306489773`*^9}, 
   3.713872646196253*^9, 3.71406253106228*^9, 
   3.7140638351040416`*^9},ExpressionUUID->"bdb4b9e4-e0e4-4ab5-bc41-\
4532cfdc2790"],

Cell[TextData[{
 "A wrench ",
 Cell[BoxData[
  FormBox[
   RowBox[{"30", "cm"}], TraditionalForm]],ExpressionUUID->
  "78cc977d-5a78-411a-9320-4e2a4905b564"],
 " long lies along the positive ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],ExpressionUUID->
  "6d22ebb6-615b-4c33-8ee1-2b44a543183a"],
 "-axis and grips a bolt at the origin. A force is applied ",
 StyleBox["in the direction",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"0", ",", "3", ",", 
     RowBox[{"-", "4"}]}], "\[RightAngleBracket]"}], TraditionalForm]],
  ExpressionUUID->"c4c260fa-1e38-44c1-8e58-2e2639853a88"],
 " at the end of the wrench. Find the magnitude of the force needed to supply \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"100", " ", 
    RowBox[{"N", "\[CenterDot]", "m"}]}], TraditionalForm]],ExpressionUUID->
  "45989996-818c-4be9-9849-f325f9fefdfd"],
 "  of torque to the bolt.\n\n",
 StyleBox["Notice! ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"0", ",", "3", ",", 
     RowBox[{"-", "4"}]}], "\[RightAngleBracket]"}], TraditionalForm]],
  ExpressionUUID->"d7cf5f36-5c5a-45c4-b65e-25904cc619ce"],
 " ",
 StyleBox["is not",
  FontWeight->"Bold"],
 " the force vector, but only a vector in the same direction as the force."
}], "Text",
 CellChangeTimes->{{3.7132369896523333`*^9, 3.7132370256061144`*^9}, {
  3.7136498172118177`*^9, 3.7136499154061193`*^9}, {3.713650060006056*^9, 
  3.713650102742618*^9}, {3.7136502356555223`*^9, 3.713650311688095*^9}, {
  3.713835323378643*^9, 3.713835337239922*^9}, {3.7140626102480373`*^9, 
  3.714062712193967*^9}, {3.7140637344701653`*^9, 3.7140638069214363`*^9}, {
  3.714068156846013*^9, 
  3.7140681658293133`*^9}},ExpressionUUID->"f48cc877-c2e7-452b-a207-\
13fd886100f0"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7146965760066338`*^9, 
  3.7146965816975145`*^9}},ExpressionUUID->"fdf7dc71-3d4f-4440-a92c-\
8bb8c7099381"],

Cell[TextData[{
 "A vector in the direction of the wrench is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["j", "^"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"0", ",", "1", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "618692db-2ff6-4adb-a585-19b12342027c"],
 " since it points along the positive ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2591eeaa-fba4-4f65-ae1a-bc997d1b1824"],
 "-axis. We can find the angle between the force and the wrench then by \
finding the angle between ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["j", "^"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e274cf1b-99ea-41b7-854b-c87d03407bd4"],
 " and \[LeftAngleBracket]0,3,-4\[RightAngleBracket]:"
}], "Text",
 CellChangeTimes->{{3.7146965760066338`*^9, 
  3.7146966939168653`*^9}},ExpressionUUID->"31d98de9-5a9f-4e7c-bc7b-\
86d47f6ef345"],

Cell[TextData[Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    RowBox[{"cos", " ", "\[Theta]"}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"0", ",", "1", ",", "0"}], "\[RightAngleBracket]"}], 
       "\[CenterDot]", 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"0", ",", "3", ",", 
         RowBox[{"-", "4"}]}], "\[RightAngleBracket]"}]}], 
      RowBox[{"||", 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"0", ",", "1", ",", "0"}], "\[RightAngleBracket]"}], "||", 
       " ", "||", 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"0", ",", "3", ",", 
         RowBox[{"-", "4"}]}], "\[RightAngleBracket]"}], "||"}]], "=", 
     RowBox[{
      FractionBox["3", 
       SqrtBox["12"]], "=", 
      FractionBox[
       SqrtBox["3"], "2"]}]}]}],
   FontSize->18], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"c4d02cc7-eea8-44b6-bd4c-55eb870bd283"]], \
"Text",
 CellChangeTimes->{{3.7146965760066338`*^9, 3.7146968024987817`*^9}},
 TextAlignment->Center,ExpressionUUID->"5bc2afd6-74bc-4592-8747-b06dbdf9ef24"],

Cell[TextData[{
 "so the angle is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    StyleBox[
     FractionBox["\[Pi]", "6"],
     FontSize->18]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "ac118b6f-8502-4a69-a954-6891db6b00d6"],
 ". Then we can set up the equation for the magnitude of torque and solve for \
the magnitude of the force:"
}], "Text",
 CellChangeTimes->{{3.7146968113032637`*^9, 
  3.714696893611714*^9}},ExpressionUUID->"2cf62c30-f5c6-4bc9-a494-\
9ffa8841213f"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"||", 
    OverscriptBox["\[Tau]", "\[RightVector]"], "||"}], "=", 
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["r", "\[RightVector]"], "||", " ", "||", 
     OverscriptBox["F", "\[RightVector]"], "||", " ", 
     RowBox[{"sin", " ", 
      RowBox[{"\[Theta]", " ", "\[DoubleLongRightArrow]", "100"}], " ", 
      RowBox[{"N", "\[CenterDot]", "m"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{".3", " ", "m"}], ")"}], "||", 
      OverscriptBox["F", "\[RightVector]"], "||", 
      RowBox[{"sin", 
       RowBox[{
        FractionBox["\[Pi]", "6"], "\[DoubleLongRightArrow]", "100"}], " ", 
       RowBox[{"N", "\[CenterDot]", "m"}]}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{".15", " ", "m"}], "||", 
       OverscriptBox["F", "\[RightVector]"], "||", 
       RowBox[{"\[DoubleLongRightArrow]", 
        RowBox[{"||", 
         OverscriptBox["F", "\[RightVector]"], "||"}]}]}], "=", 
      RowBox[{
       RowBox[{
        FractionBox["100", ".15"], "N"}], "=", 
       RowBox[{
        RowBox[{
         FractionBox["2000", "3"], " ", "N"}], "\[TildeTilde]", 
        RowBox[{"666.67", " ", "N"}]}]}]}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"f0587ead-b67d-4ac4-8d9e-c3f881410051"]], \
"Text",
 CellChangeTimes->{{3.7146968113032637`*^9, 3.714697081143357*^9}},
 TextAlignment->Center,ExpressionUUID->"f4a00c80-5510-4941-a9d1-667801e76d2c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 12 (Little Challenge)", "Section",
 CellChangeTimes->{{3.713236043904008*^9, 3.713236045023195*^9}, {
   3.713835658285311*^9, 3.713835663773138*^9}, 3.7138726490089736`*^9, 
   3.714063836359789*^9, {3.7146966833919735`*^9, 
   3.7146966843350906`*^9}},ExpressionUUID->"feb30fc7-7eb1-49f5-9026-\
f00ef675d0a8"],

Cell["Show that", "Text",
 CellChangeTimes->{{3.7132370804592648`*^9, 3.713237151603834*^9}, {
   3.7132371849388576`*^9, 3.713237188708766*^9}, 3.713237221809761*^9, {
   3.713468989450657*^9, 3.713468996554131*^9}, {3.7136511180228157`*^9, 
   3.7136511403920093`*^9}, {3.713835677483931*^9, 3.7138357399262533`*^9}, {
   3.7138358169191837`*^9, 3.7138358213433695`*^9}, {3.7138358901459007`*^9, 
   3.7138359249292536`*^9}, {3.714062824188186*^9, 
   3.7140628297748957`*^9}},ExpressionUUID->"664b5388-9817-4cb3-be39-\
505b6a391a10"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     RowBox[{
      OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
      OverscriptBox["b", "\[RightVector]"]}], 
     SuperscriptBox["||", "2"]}], "=", 
    RowBox[{"||", 
     OverscriptBox["a", "\[RightVector]"], 
     SuperscriptBox["||", "2"], "||", 
     OverscriptBox["b", "\[RightVector]"], 
     SuperscriptBox["||", "2"], 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
         OverscriptBox["b", "\[RightVector]"]}], ")"}], "2"]}]}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8de92961-970d-4d2c-aa14-19e24d069502"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132370804592648`*^9, 3.713237151603834*^9}, {
   3.7132371849388576`*^9, 3.713237188708766*^9}, 3.713237221809761*^9, {
   3.713468989450657*^9, 3.713468996554131*^9}, {3.7136511180228157`*^9, 
   3.7136511403920093`*^9}, {3.713835677483931*^9, 3.7138357399262533`*^9}, {
   3.7138358169191837`*^9, 3.7138358213433695`*^9}, {3.7138358901459007`*^9, 
   3.7138359249292536`*^9}, {3.714062824188186*^9, 3.714062922703368*^9}, {
   3.714062963614378*^9, 3.7140629650800323`*^9}},
 TextAlignment->Center,ExpressionUUID->"db216d7d-4016-4630-9055-6a16a5e2dcf9"],

Cell[TextData[{
 StyleBox["Hint:",
  FontSlant->"Italic"],
 " write out ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
     OverscriptBox["b", "\[RightVector]"]}], 
    SuperscriptBox["||", "2"]}], TraditionalForm]],ExpressionUUID->
  "1794cf51-ff9b-4525-a207-09b7cda6faea"],
 " in terms of the angle between the vectors then use the Pythagorean trig \
identity on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sin", "2"], "\[Theta]"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5774504a-adfe-4fcb-ab60-b35e6a8299e6"],
 ". Do not try to work on both sides of the equation at one time; start with \
one side and work it into the other."
}], "Text",
 CellChangeTimes->{{3.7132370804592648`*^9, 3.713237151603834*^9}, {
   3.7132371849388576`*^9, 3.713237188708766*^9}, 3.713237221809761*^9, {
   3.713468989450657*^9, 3.713468996554131*^9}, {3.7136511180228157`*^9, 
   3.7136511403920093`*^9}, {3.713835677483931*^9, 3.7138357399262533`*^9}, {
   3.7138358169191837`*^9, 3.7138358213433695`*^9}, {3.7138358901459007`*^9, 
   3.7138359249292536`*^9}, {3.714062824188186*^9, 3.714062922703368*^9}, {
   3.714062963614378*^9, 3.7140630582438354`*^9}, {3.714063651805521*^9, 
   3.714063671405774*^9}},ExpressionUUID->"8d88a800-be93-40a0-9725-\
708fd8cb02fb"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7146970960353775`*^9, 
  3.714697098768097*^9}},ExpressionUUID->"312d8025-9c80-4299-85c8-\
241970aa4478"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"||", 
          RowBox[{
           OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
           OverscriptBox["b", "\[RightVector]"]}], 
          SuperscriptBox["||", "2"]}], "=", 
         RowBox[{"||", 
          OverscriptBox["a", "\[RightVector]"], 
          SuperscriptBox["||", "2"], "||", 
          OverscriptBox["b", "\[RightVector]"], 
          SuperscriptBox["||", "2"], 
          RowBox[{
           SuperscriptBox["sin", "2"], "\[Theta]"}]}]}]},
       {
        RowBox[{"=", 
         RowBox[{"||", 
          OverscriptBox["a", "\[RightVector]"], 
          SuperscriptBox["||", "2"], "||", 
          OverscriptBox["b", "\[RightVector]"], 
          SuperscriptBox["||", "2"], 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             SuperscriptBox["cos", "2"], "\[Theta]"}]}], ")"}]}]}]},
       {
        RowBox[{"=", 
         RowBox[{"||", 
          OverscriptBox["a", "\[RightVector]"], 
          SuperscriptBox["||", "2"], "||", 
          OverscriptBox["b", "\[RightVector]"], 
          SuperscriptBox["||", "2"], 
          RowBox[{"-", 
           RowBox[{"||", 
            OverscriptBox["a", "\[RightVector]"], 
            SuperscriptBox["||", "2"], "||", 
            OverscriptBox["b", "\[RightVector]"], 
            SuperscriptBox["||", "2"], 
            RowBox[{
             SuperscriptBox["cos", "2"], "\[Theta]"}]}]}]}]}]},
       {
        RowBox[{"=", 
         RowBox[{"||", 
          OverscriptBox["a", "\[RightVector]"], 
          SuperscriptBox["||", "2"], "||", 
          OverscriptBox["b", "\[RightVector]"], 
          SuperscriptBox["||", "2"], 
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
              OverscriptBox["b", "\[RightVector]"]}], ")"}], "2"]}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"9339b36a-ad03-4a61-860a-2f081c6c8a23"]], \
"Text",
 CellChangeTimes->{{3.7146971118969655`*^9, 3.7146971311403384`*^9}, {
  3.7146976567859263`*^9, 
  3.7146977488349323`*^9}},ExpressionUUID->"0db3d680-5b15-4c24-9341-\
dfef1f9bf8f8"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 231, 4, 101, "Title", "ExpressionUUID" -> \
"3eff84e4-7dc3-473c-9d5f-5004e7960755"],
Cell[CellGroupData[{
Cell[836, 30, 530, 10, 115, "Chapter", "ExpressionUUID" -> \
"5b65f4e8-cea9-44b9-aede-fa6ba26bdd89"],
Cell[1369, 42, 383, 7, 30, "Text", "ExpressionUUID" -> \
"76986328-9708-4592-8069-c192c864c775"],
Cell[CellGroupData[{
Cell[1777, 53, 397, 10, 22, "Code", "ExpressionUUID" -> \
"75b51ea8-3cf4-4f7d-b8ba-743bdfc5b198",
 CellOpen->False],
Cell[2177, 65, 831, 22, 30, "Output", "ExpressionUUID" -> \
"706fd091-0d1c-4039-b85d-b12ae85a78f0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3045, 92, 207, 4, 70, "Section", "ExpressionUUID" -> \
"03899cad-2d7f-4aa5-9757-7093b5aa4e28"],
Cell[3255, 98, 666, 12, 30, "Text", "ExpressionUUID" -> \
"8ca8a4c2-3c15-486e-8538-896de7f66e0e"],
Cell[CellGroupData[{
Cell[3946, 114, 1129, 22, 41, "ItemNumbered", "ExpressionUUID" -> \
"d4ccd7aa-9643-465a-8ad2-4bcc04cc301d"],
Cell[5078, 138, 1129, 22, 41, "ItemNumbered", "ExpressionUUID" -> \
"e90830b2-69f7-4cb8-a397-821128b6c822"],
Cell[6210, 162, 1085, 22, 41, "ItemNumbered", "ExpressionUUID" -> \
"2108ade3-702e-4645-8ac4-f63d285d0ca7"],
Cell[7298, 186, 1125, 22, 41, "ItemNumbered", "ExpressionUUID" -> \
"6f434200-6a5e-4a4c-a90f-e7a7458fb6e7"],
Cell[8426, 210, 1233, 25, 41, "ItemNumbered", "ExpressionUUID" -> \
"22e5d1a4-0b06-45fb-9a27-ba314667b789"],
Cell[9662, 237, 1243, 25, 41, "ItemNumbered", "ExpressionUUID" -> \
"0ae83a95-bb90-400b-9f61-9d78ddf8adbf"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10954, 268, 158, 3, 70, "Section", "ExpressionUUID" -> \
"38cc62da-8763-4d8f-ac77-780f62bc6421"],
Cell[11115, 273, 1126, 22, 33, "Text", "ExpressionUUID" -> \
"b5fb625e-5ac9-4c5b-a73a-901fa400cef1"],
Cell[CellGroupData[{
Cell[12266, 299, 1482, 30, 32, "ItemNumbered", "ExpressionUUID" -> \
"b2988ef3-402d-4aab-9f99-cca069ecce0b"],
Cell[13751, 331, 1686, 38, 34, "ItemNumbered", "ExpressionUUID" -> \
"41803f9c-cae0-43bb-9d02-721271aa32bb"],
Cell[15440, 371, 1631, 35, 34, "ItemNumbered", "ExpressionUUID" -> \
"252a1eac-647b-4a36-a985-d94fc1b875a5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17108, 411, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"d8c1f8fe-1eb1-4df7-b516-2348173a1ba6"],
Cell[CellGroupData[{
Cell[17291, 418, 1429, 44, 74, "ItemNumbered", "ExpressionUUID" -> \
"a3e2c17a-f982-4034-b869-fa80c5b7e467"],
Cell[18723, 464, 1485, 46, 74, "ItemNumbered", "ExpressionUUID" -> \
"121ef57f-3097-49cb-8529-4103f5875495"],
Cell[20211, 512, 2198, 67, 74, "ItemNumbered", "ExpressionUUID" -> \
"1a741c99-723c-475d-b71b-94a6ca28a1b3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22470, 586, 156, 3, 70, "Section", "ExpressionUUID" -> \
"b558e9de-89e6-468c-a384-951f2a0bdef8"],
Cell[22629, 591, 1077, 18, 30, "Text", "ExpressionUUID" -> \
"174c6873-057c-4455-bb2c-f643f624b6ff",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[23731, 613, 1330, 26, 40, "ItemNumbered", "ExpressionUUID" -> \
"f8e2e0c7-736a-4958-8911-8846b778879c",
 InitializationCell->True],
Cell[25064, 641, 1366, 27, 40, "ItemNumbered", "ExpressionUUID" -> \
"970dff80-1b18-4579-9d8f-60558dd36a98",
 InitializationCell->True],
Cell[26433, 670, 1295, 26, 40, "ItemNumbered", "ExpressionUUID" -> \
"ba274bf8-5935-4616-820b-611606e90702",
 InitializationCell->True],
Cell[27731, 698, 1384, 29, 40, "ItemNumbered", "ExpressionUUID" -> \
"dde223e0-5eb6-44a7-ade8-61ff0402378f",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[29152, 732, 154, 2, 49, "Subsection", "ExpressionUUID" -> \
"746d3e2f-8edf-4547-a337-f178995e2ac8"],
Cell[CellGroupData[{
Cell[29331, 738, 1553, 32, 41, "ItemNumbered", "ExpressionUUID" -> \
"6377f3ab-94ce-4b6f-822a-bb887fd1595c",
 InitializationCell->True],
Cell[30887, 772, 1607, 34, 41, "ItemNumbered", "ExpressionUUID" -> \
"e144aa2f-c0c1-436f-879f-3920aa31f1c1",
 InitializationCell->True],
Cell[32497, 808, 1941, 49, 40, "ItemNumbered", "ExpressionUUID" -> \
"9356d0e0-99e9-41dd-80ab-2071f980df02",
 InitializationCell->True],
Cell[34441, 859, 2298, 59, 41, "ItemNumbered", "ExpressionUUID" -> \
"c5113f79-2815-4449-913d-ac062677719e",
 InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36800, 925, 156, 3, 70, "Section", "ExpressionUUID" -> \
"d9f59dcc-177e-49cd-b037-24d5bddbc1a0"],
Cell[36959, 930, 1283, 28, 33, "Text", "ExpressionUUID" -> \
"96795a05-1591-4a13-b703-2430f29274a0"],
Cell[CellGroupData[{
Cell[38267, 962, 2718, 77, 19, "Input", "ExpressionUUID" -> \
"fdcd992f-ba4a-47a9-8c36-5a00cff3243d",
 CellOpen->False],
Cell[40988, 1041, 4473, 79, 253, "Output", "ExpressionUUID" -> \
"33a6342d-85c4-412a-b8a2-f278541c857f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45498, 1125, 2410, 73, 19, "Input", "ExpressionUUID" -> \
"2c6bbcd0-c436-44ce-9791-808b460f5cab",
 CellOpen->False],
Cell[47911, 1200, 8333, 144, 218, "Output", "ExpressionUUID" -> \
"df386c2c-711d-413c-a4a1-7224d0a06924"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56281, 1349, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"b67230a7-ccfa-481f-a426-cf74c75e5d19"],
Cell[CellGroupData[{
Cell[56466, 1356, 1680, 47, 54, "ItemNumbered", "ExpressionUUID" -> \
"ebc36f3f-c875-47c6-8968-0f2ab9981cb6"],
Cell[58149, 1405, 2267, 61, 74, "ItemNumbered", "ExpressionUUID" -> \
"077aff88-f865-4e7c-9cbe-ad2ea2824a44"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60477, 1473, 155, 3, 70, "Section", "ExpressionUUID" -> \
"51845899-4359-4829-b905-84276d313cc9"],
Cell[60635, 1478, 608, 16, 35, "Text", "ExpressionUUID" -> \
"67bd11bf-8581-4bcc-a90a-f92da96d15ea"],
Cell[61246, 1496, 605, 17, 42, "Text", "ExpressionUUID" -> \
"24c4f408-caed-41cc-adfb-3d60c340697f"],
Cell[CellGroupData[{
Cell[61876, 1517, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"b9237059-50ba-4048-a08f-ef2addf70aa9"],
Cell[62035, 1522, 284, 7, 30, "Text", "ExpressionUUID" -> \
"67a2ee23-73e4-43f2-9160-e0c84287d950"],
Cell[62322, 1531, 2711, 75, 100, "Text", "ExpressionUUID" -> \
"0eb97ab2-def0-4c3c-ad80-1af415e70ae6"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65082, 1612, 257, 4, 70, "Section", "ExpressionUUID" -> \
"8a849707-7d64-4ab6-84bd-d2ca7003e56a"],
Cell[65342, 1618, 1051, 23, 30, "Text", "ExpressionUUID" -> \
"2ccb428a-117c-4cd2-9f13-4839352852dc"],
Cell[CellGroupData[{
Cell[66418, 1645, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"b03bd0d6-14f8-409f-9edc-ca5199e31c7b"],
Cell[66579, 1650, 244, 6, 30, "Text", "ExpressionUUID" -> \
"437800bd-4d36-4c42-9dfb-d0d29d1b01ea"],
Cell[66826, 1658, 1612, 47, 73, "Text", "ExpressionUUID" -> \
"0eba511b-0dd1-41d5-88c4-a215def4a7cb"],
Cell[68441, 1707, 275, 6, 30, "Text", "ExpressionUUID" -> \
"1148cb5b-91b6-415e-a568-d80b08d86015"],
Cell[68719, 1715, 1374, 43, 86, "Text", "ExpressionUUID" -> \
"d316c813-33c4-4e3e-bb50-2e841e5f9095"],
Cell[70096, 1760, 479, 12, 32, "Text", "ExpressionUUID" -> \
"b6093a45-6865-4df9-9d9f-072224b65948"],
Cell[70578, 1774, 942, 29, 51, "Text", "ExpressionUUID" -> \
"49f3a36d-146a-4c0f-a2d1-3efc2b7f348b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71569, 1809, 230, 4, 70, "Section", "ExpressionUUID" -> \
"213b8a14-dd5d-4c8b-839d-d0746db10921"],
Cell[71802, 1815, 1400, 33, 30, "Text", "ExpressionUUID" -> \
"140bdf55-ab75-4f74-9e26-7f21c5377a32"],
Cell[CellGroupData[{
Cell[73227, 1852, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"10c9ed3d-3556-452a-9a5e-b965bb42103f"],
Cell[73386, 1857, 578, 16, 35, "Text", "ExpressionUUID" -> \
"f2c20206-9b40-439b-84b6-8839a20334e7"],
Cell[73967, 1875, 1369, 37, 62, "Text", "ExpressionUUID" -> \
"45026146-f1f0-4d36-8d50-29e2e9c8c528"],
Cell[75339, 1914, 244, 6, 30, "Text", "ExpressionUUID" -> \
"eb6abd14-bf48-4491-8f3b-5ff1d0a39cc6"],
Cell[75586, 1922, 1283, 39, 73, "Text", "ExpressionUUID" -> \
"bf1c4e34-ff31-4b26-b47a-875cebee5fd5"],
Cell[76872, 1963, 678, 19, 35, "Text", "ExpressionUUID" -> \
"7afa56e8-d6b0-4e6a-908d-1c091be082dd"],
Cell[77553, 1984, 728, 20, 51, "Text", "ExpressionUUID" -> \
"bedc1797-3577-4232-8da9-78487a3b562f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78330, 2010, 207, 4, 70, "Section", "ExpressionUUID" -> \
"dae64fe3-d030-402a-99bd-33d99c0fb7f0"],
Cell[78540, 2016, 1232, 28, 35, "Text", "ExpressionUUID" -> \
"f42c23bc-d166-4763-8758-4c71e5ee6cd1"],
Cell[CellGroupData[{
Cell[79797, 2048, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"b28ec24c-0567-4343-9829-9942f4b2bd80"],
Cell[79960, 2053, 587, 16, 42, "Text", "ExpressionUUID" -> \
"c7138308-5923-4623-b72b-137b4b7c705a"],
Cell[80550, 2071, 1205, 36, 67, "Text", "ExpressionUUID" -> \
"14f8a537-24c5-4633-93e4-5c6de5348b28"],
Cell[81758, 2109, 397, 11, 30, "Text", "ExpressionUUID" -> \
"cac7b7b5-c958-423f-af62-62d82dc197b7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82204, 2126, 408, 6, 70, "Section", "ExpressionUUID" -> \
"64ce845d-da60-4d4e-bfd3-41d25d97b1d1"],
Cell[82615, 2134, 1243, 29, 42, "Text", "ExpressionUUID" -> \
"95b56bc2-8c0d-47d9-8d6c-692117207b10"],
Cell[CellGroupData[{
Cell[83883, 2167, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"a3d9f5e9-b54b-4332-9e62-7a398c17f208"],
Cell[84044, 2172, 566, 12, 49, "Text", "ExpressionUUID" -> \
"f79a5bd9-821b-48df-99b5-2646ef9b193e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84659, 2190, 157, 3, 70, "Section", "ExpressionUUID" -> \
"ed386bc4-9385-4728-a0dd-c3eb5d341cf5"],
Cell[84819, 2195, 1013, 28, 49, "Text", "ExpressionUUID" -> \
"a236b3ef-4fd9-4909-982f-141acc7ea011"],
Cell[85835, 2225, 65076, 1070, 230, "Input", "ExpressionUUID" -> \
"31c5aded-e8d1-4922-ab16-6a4f9fb64101"],
Cell[CellGroupData[{
Cell[150936, 3299, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"afdf70a0-5402-46d3-b9e2-eefb4865c38e"],
Cell[151099, 3304, 1695, 48, 67, "Text", "ExpressionUUID" -> \
"d90634a0-cdb0-4eb5-b68b-9d721d2c7fab"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[152843, 3358, 387, 6, 70, "Section", "ExpressionUUID" -> \
"bdb4b9e4-e0e4-4ab5-bc41-4532cfdc2790"],
Cell[153233, 3366, 1823, 48, 87, "Text", "ExpressionUUID" -> \
"f48cc877-c2e7-452b-a207-13fd886100f0"],
Cell[CellGroupData[{
Cell[155081, 3418, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"fdf7dc71-3d4f-4440-a92c-8bb8c7099381"],
Cell[155244, 3423, 1002, 27, 57, "Text", "ExpressionUUID" -> \
"31d98de9-5a9f-4e7c-bc7b-86d47f6ef345"],
Cell[156249, 3452, 1130, 31, 55, "Text", "ExpressionUUID" -> \
"5bc2afd6-74bc-4592-8747-b06dbdf9ef24"],
Cell[157382, 3485, 519, 15, 44, "Text", "ExpressionUUID" -> \
"2cf62c30-f5c6-4bc9-a494-9ffa8841213f"],
Cell[157904, 3502, 1486, 39, 43, "Text", "ExpressionUUID" -> \
"f4a00c80-5510-4941-a9d1-667801e76d2c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[159439, 3547, 325, 5, 70, "Section", "ExpressionUUID" -> \
"feb30fc7-7eb1-49f5-9026-f00ef675d0a8"],
Cell[159767, 3554, 536, 8, 30, "Text", "ExpressionUUID" -> \
"664b5388-9817-4cb3-be39-505b6a391a10"],
Cell[160306, 3564, 1331, 32, 44, "Text", "ExpressionUUID" -> \
"db216d7d-4016-4630-9055-6a16a5e2dcf9"],
Cell[161640, 3598, 1367, 31, 54, "Text", "ExpressionUUID" -> \
"8d88a800-be93-40a0-9725-708fd8cb02fb"],
Cell[CellGroupData[{
Cell[163032, 3633, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"312d8025-9c80-4299-85c8-241970aa4478"],
Cell[163193, 3638, 2382, 66, 124, "Text", "ExpressionUUID" -> \
"0db3d680-5b15-4c24-9341-dfef1f9bf8f8"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

